#!/usr/bin/env python3
import sys
import re
import subprocess 
import shlex
import json

inf = json.loads(sys.argv[1])

# split user text into URL + extra yt-dlp args
parts = shlex.split(inf["txt"])
url = parts[0]
		
if re.search(
				r'^((?:https?:)?//)?'
				r'((?:www|m)\.)?'
				r'((?:youtube(?:-nocookie)?\.com|youtu\.be))'
				r'(\/(?:[\w\-]+\?v=|embed\/|live\/|v\/)?)([\w\-]+)'
				r'(\S+)?$',
				url
		):
    subprocess.run([sys.executable, "/var/lib/copyparty/repos/copyparty-hooks/youtube.py", sys.argv[1]])
else:
    subprocess.run([sys.executable, "/var/lib/copyparty/bin/hooks/wget.py", sys.argv[1]])
