#!/usr/bin/env python3

import os
import sys
import json
import subprocess as sp
import re


_ = r"""
modified version of the wget hook

use copyparty as a file downloader by POSTing URLs as
application/x-www-form-urlencoded (for example using the
📟 message-to-server-log in the web-ui)

example usage as global config:
    --xm aw,f,j,t3600,bin/hooks/youtube.py

parameters explained,
    xm = execute on message-to-server-log
    aw = only users with write-access can use this
    f = fork; don't delay other hooks while this is running
    j = provide message information as json (not just the text)
    c3 = mute all output
    t3600 = timeout and abort download after 1 hour

example usage as a volflag (per-volume config):
    -v srv/inc:inc:r:rw,ed:c,xm=aw,f,j,t3600,bin/hooks/youtube.py
                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

    (share filesystem-path srv/inc as volume /inc,
     readable by everyone, read-write for user 'ed',
     running this plugin on all messages with the params explained above)

example usage as a volflag in a copyparty config file:
    [/inc]
      srv/inc
      accs:
        r: *
        rw: ed
      flags:
        xm: aw,f,j,t3600,bin/hooks/youtube.py

the volflag examples only kicks in if you send the message
while you're in the /inc folder (or any folder below there)
"""
EXECUTABLE = "yt-dlp"
QUALITY = "bv+ba/b" # dl and combine best video/best audio OR dl best combined
OUTPUT_NAME = "%(title)s [%(id)s].%(ext)s" # official default

def main():
    log = open("log.txt", "a")
    log.write(sys.argv[1])
    inf = json.loads(sys.argv[1])
    url = inf["txt"]
    if re.search(r'^((?:https?:)?\/\/)?((?:www|m)\.)?((?:youtube(?:-nocookie)?\.com|youtu.be))(\/(?:[\w\-]+\?v=|embed\/|live\/|v\/)?)([\w\-]+)(\S+)?$', url) is None:
        raise Exception(f"not a youtube link {url}")

    os.chdir(inf["ap"])

    name = url.split("?")[0].split("/")[-1]
    tfn = "-- DOWNLOADING " + name
    print(f"{tfn}\n", end="")
    open(tfn, "wb").close()

    cmd = [EXECUTABLE, "-f", QUALITY, "-o", OUTPUT_NAME, url]

    try:
        status = 0
        sp.check_call(cmd)
    except:
        status = 1
        t = "-- FAILED TO DONWLOAD " + name
        print(f"{t}\n", end="")
        open(t, "wb").close()

    os.unlink(tfn)

    sys.exit(status)


if __name__ == "__main__":
    main()
