#!/usr/bin/env python3
1 // len(r"""

/*
  # YT-DLP Plugin
  Hook written by weirdrock (https://ko-fi.com/weirdrockk), UI by Varphi
  
  ## Installation Instructions:
  > There are two path conventions used in this setup, please be careful to make sure you are using the correct ones!
  
  1. Put youtube.py.js into a folder that you'll be OK with being at least read only for all users you want to have access to the theme.
  2. Add that folder to your Copyparty config, with again, at minimum read permissions, allowing the user-agent to make a GET request.
  3. Windows:
     - CLI Arguments: --js-other=/<copyparty path NOT NATIVE FILESYSTEM PATH to>/youtube.py.js -v <VOLUME>:<VOLCONF>,xm=aw,f,j,t3600,<DRIVE>:\native path NOT Copyparty PATH to\python.exe,<DRIVE>:\native path NOT Copyparty PATH to\youtube.py

     - Config file:
       [global]
             js-other: /<copyparty path NOT NATIVE FILESYSTEM PATH to>/youtube.py.js
       [/some-volume]
             # VOLCONF
             flags:
                xm: aw,f,j,t3600,<DRIVE>:\native path NOT Copyparty PATH to\python.exe,<DRIVE>:\native path NOT Copyparty PATH to\youtube.py.js
  
     Unix:
     - CLI Arguments: --js-other=/<copyparty path NOT NATIVE FILESYSTEM PATH to>/youtube.py.js -v <VOLUME>:<VOLCONF>,xm=aw,f,j,t3600,/native path NOT Copyparty PATH to/python.exe,/native path NOT Copyparty PATH to/youtube.py
     
     - Config file:
     - [global]
             js-other: /<copyparty path NOT NATIVE FILESYSTEM PATH to>/youtube.py.js
       [/some-volume]
             # VOLCONF
             flags:
                xm: aw,f,j,t3600,/native path NOT Copyparty PATH to/youtube.py.js
  4. Restart Copyparty or click "reload config" on the control panel. (Restarting is usually preferred)
  5. Test by downloading a video to the defined volume
  
  ## Notes
  - You will need ffmpeg and yt-dlp installed on your system, preferably in the PATH environment variable. If your executable for yt-dlp is not named "yt-dlp" change the EXECUTABLE variable in the python section of this file to the correct name/path if it is not in your PATH.
  - I have left weirdrock's explanation of their hook in the python section, as well as the installation instructions in the case these may not be sufficient or make sense, so check there if you're having issues :).
  */

function HS(htmlString) {
	var div = document.createElement("div");
	div.innerHTML = htmlString.trim();
	return div.firstChild;
}

var PL_NAME = "plg";

if (!ebi("op_plg")) {
	var pl_btn = HS(
		'<a href="#" id="opa_plg" data-dest="plg" tt="YT-DLP"><svg width="24" height="24" viewBox="0 0 461 461" xmlns="http://www.w3.org/2000/svg" style="fill:#F61C0D; height: 1.1em; width: 1.1em; margin: 0px; margin-bottom: -0.2em;"><path d="M365.257,67.393H95.744C42.866,67.393,0,110.259,0,163.137v134.728 c0,52.878,42.866,95.744,95.744,95.744h269.513c52.878,0,95.744-42.866,95.744-95.744V163.137 C461.001,110.259,418.135,67.393,365.257,67.393z M300.506,237.056l-126.06,60.123c-3.359,1.602-7.239-0.847-7.239-4.568V168.607 c0-3.774,3.982-6.22,7.348-4.514l126.06,63.881C304.363,229.873,304.298,235.248,300.506,237.056z"/></svg></a>',
	);
	ebi("ops").insertBefore(pl_btn, ebi("ops").lastChild);
	pl_btn.onclick = opclick;
	pl_btn.href = "#v=" + pl_btn.getAttribute("data-dest");
}

if (!ebi("op_plg")) {
	ebi("op_cfg").insertAdjacentHTML(
		"afterend",
		'<div id="op_plg" class="opview opbox"></div>',
	);
}

//
ebi("op_plg").innerHTML =
	"<h3>yt-dlp</h3>" +
	'<form id="plg_form" onsubmit="return false;">' +
	'<div id="plg_txt">' +
	'    <div class="plg_row">' +
	'        <label for="plg_url">URL</label>' +
	'        <input type="text" id="plg_url" name="url" placeholder="https://www.youtube.com/watch?v=..." />' +
	"    </div>" +
	'<div class="plg_row">' +
	'        <label for="plg_adv">Advanced/Manual Flags</label>' +
	'        <input type="text" id="plg_adv" name="adv" placeholder="--cookies-from-browser firefox" />' +
	"    </div>" +
	"    </div>" +
	'    <div id="plg_opts">' +
	"    <div>" +
	"        <h4>Download Type</h4>" +
	'        <div id="plg_dl_type">' +
	'            <a href="#" class="tgl btn on" data-group="dl_type" data-value="audiovideo">Audio + Video</a>' +
	'            <a href="#" class="tgl btn" data-group="dl_type" data-value="video">Video only</a>' +
	'            <a href="#" class="tgl btn" data-group="dl_type" data-value="audio">Audio only</a>' +
	"        </div>" +
	"    </div>" +
	'    <div id="plg_video_options">' +
	"        <h4>Video Quality</h4>" +
	'        <div id="plg_video_quality">' +
	'            <a href="#" class="tgl btn on" data-group="video_quality" data-cmd=\'-f "bv*+ba/b"\'>Best</a>' +
	'            <a href="#" class="tgl btn" data-group="video_quality" data-cmd=\'-f "bv*[height<=2160]+ba/b"\'>4K (2160p)</a>' +
	'            <a href="#" class="tgl btn" data-group="video_quality" data-cmd=\'-f "bv*[height<=1440]+ba/b"\'>1440p</a>' +
	'            <a href="#" class="tgl btn" data-group="video_quality" data-cmd=\'-f "bv*[height<=1080]+ba/b"\'>1080p</a>' +
	'            <a href="#" class="tgl btn" data-group="video_quality" data-cmd=\'-f "bv*[height<=720]+ba/b"\'>720p</a>' +
	'            <a href="#" class="tgl btn" data-group="video_quality" data-cmd=\'-f "bv*[height<=480]+ba/b"\'>480p</a>' +
	"        </div>" +
	"    </div>" +
	'    <div id="plg_audio_options" style="display:none;">' +
	"        <h4>Audio Format</h4>" +
	'        <div id="plg_audio_fmt">' +
	'            <a href="#" class="tgl btn on" data-group="audio_fmt" data-cmd="">best</a>' +
	'            <a href="#" class="tgl btn" data-group="audio_fmt" data-cmd="--audio-format mp3">mp3</a>' +
	'            <a href="#" class="tgl btn" data-group="audio_fmt" data-cmd="--audio-format flac">flac</a>' +
	'            <a href="#" class="tgl btn" data-group="audio_fmt" data-cmd="--audio-format opus">opus</a>' +
	'            <a href="#" class="tgl btn" data-group="audio_fmt" data-cmd="--audio-format m4a">m4a</a>' +
	'            <a href="#" class="tgl btn" data-group="audio_fmt" data-cmd="--audio-format wav">wav</a>' +
	"        </div>" +
	"    </div>" +
	"    <div>" +
	"        <h4>Metadata / Post-processing</h4>" +
	'        <div id="plg_metadata_opts">' +
	'            <a href="#" class="tgl btn" data-cmd="--embed-thumbnail">Embed thumbnail</a>' +
	'            <a href="#" class="tgl btn" data-cmd="--add-metadata">Add metadata</a>' +
	'            <a href="#" class="tgl btn" data-cmd="--embed-chapters">Embed chapters</a>' +
	'            <a href="#" class="tgl btn" data-cmd="--embed-subs --write-subs">Embed subtitles</a>' +
	"        </div>" +
	"    </div>" +
	"    <div>" +
	"        <h4>Playlist</h4>" +
	'        <div id="plg_playlist_opts">' +
	'            <a href="#" class="tgl btn on" data-group="playlist" data-cmd="--no-playlist">Download single video</a>' +
	'            <a href="#" class="tgl btn" data-group="playlist" data-cmd="--yes-playlist">Download full playlist</a>' +
	'            <a href="#" class="tgl btn" data-group="playlist" data-cmd=\'--yes-playlist -o "%(playlist_index)s - %(title)s.%(ext)s"\'>Number tracks</a>' +
	"        </div>" +
	"    </div>" +
	"    </div>" +
	'    <div id="plg_cmd" class="plg_row">' +
	'        <input type="submit" value="🔽 Download" />' +
	'        <div id="plg_status" class="msg"></div>' +
	"    </div>" +
	"</form>" +
	"<style>" +
	"#op_plg.act {display: flex; align-items: center; flex-direction: column;}" +
	"#op_plg h3 {margin: 0px;}" +
	"#plg_txt {display: flex; gap: 1em; padding: 0.4em;}" +
	"#plg_txt .plg_row {display: flex; flex-direction: column; width: 100%;}" +
	"#plg_opts {display: flex; padding: 0.4em;}" +
	"#plg_cmd {padding: 0.4em; display: flex; width: 100%; align-items: center;}" +
	"#plg_cmd * {width: 100%;}" +
	"html.e #opa_plg svg {margin-bottom: 0px !important;}" +
	"</style>";

var ytdlp = (function() {
	var r = {},
		form,
		url_in,
		adv_in,
		status,
		audio_opts_div,
		video_opts_div;

	function build_cmd() {
		var url = url_in.value.trim();
		if (!url) {
			return "";
		}

		var parts = [url];
		var dl_type = (QS("#plg_dl_type a.tgl.on") || {}).getAttribute(
			"data-value",
		);

		// Handle primary mode and format
		if (dl_type === "audio") {
			parts.push("-x");
			var audio_fmt_cmd = (QS("#plg_audio_fmt a.tgl.on") || {}).getAttribute(
				"data-cmd",
			);
			if (audio_fmt_cmd) {
				parts.push(audio_fmt_cmd);
			}
		} else {
			// audiovideo or video
			var video_quality_cmd = (
				QS("#plg_video_quality a.tgl.on") || {}
			).getAttribute("data-cmd");
			if (video_quality_cmd) {
				if (dl_type === "video") {
					// Remove the audio part from the format string, e.g., turn "-f 'bv*+ba/b'" into "-f 'bv*'"
					parts.push(video_quality_cmd.replace(/\+ba(\/b)?/, ""));
				} else {
					parts.push(video_quality_cmd);
				}
			}
		}

		// Handle other checkbox-style options
		var metadata_opts = QSA("#plg_metadata_opts a.tgl.on");
		for (var i = 0; i < metadata_opts.length; i++) {
			parts.push(metadata_opts[i].getAttribute("data-cmd"));
		}

		var playlist_opt = QS("#plg_playlist_opts a.tgl.on");
		if (playlist_opt) {
			parts.push(playlist_opt.getAttribute("data-cmd"));
		}

		var adv = adv_in.value.trim();
		if (adv) {
			parts.push(adv);
		}

		return parts.join(" ");
	}

	function on_change(e) {
		if (e && e.target) {
			var tgt = e.target.closest("a.tgl");
			if (tgt) {
				var group = tgt.getAttribute("data-group");
				if (group) {
					// Radio button behavior
					var group_btns = QSA('#plg_form a.tgl[data-group="' + group + '"]');
					for (var i = 0; i < group_btns.length; i++) {
						clmod(group_btns[i], "on", false);
					}
					clmod(tgt, "on", true);
				} else {
					// Checkbox behavior
					clmod(tgt, "on", "t");
				}
			}
		}

		var dl_type = (QS("#plg_dl_type a.tgl.on") || {}).getAttribute(
			"data-value",
		);
		audio_opts_div.style.display = dl_type === "audio" ? "" : "none";
		video_opts_div.style.display = dl_type === "audio" ? "none" : "";
	}

	function submit(e) {
		ev(e);
		var cmd = build_cmd();

		if (!cmd) {
			status.textContent = "URL is required";
			clmod(status, "vis", 1);
			setTimeout(function() {
				clmod(status, "vis");
			}, 3000);
			return false;
		}

		status.textContent = "sending...";
		clmod(status, "vis", 1);

		var xhr = new XHR(),
			ct = "application/x-www-form-urlencoded;charset=UTF-8";

		xhr.msg = cmd;
		xhr.open("POST", get_evpath(), true);
		xhr.responseType = "text";
		xhr.onload = xhr.onerror = cb;
		xhr.setRequestHeader("Content-Type", ct);
		if (xhr.overrideMimeType) xhr.overrideMimeType("Content-Type", ct);

		xhr.send("msg=" + uricom_enc(xhr.msg));
		return false;
	}

	function cb() {
		xhrchk(this, "could not send message", "404: Parent folder not found");

		if (this.status < 200 || this.status > 202) {
			status.textContent = "error: " + hunpre(this.responseText);
			return;
		}

		var txt = "sent: <code>" + esc(this.msg) + "</code>";
		if (this.status == 202)
			txt += "<br />&nbsp; got: <code>" + esc(this.responseText) + "</code>";

		status.innerHTML = txt;
		setTimeout(function() {
			clmod(status, "vis");
		}, 5000);
	}

	r.init = function() {
		form = ebi("plg_form");
		url_in = ebi("plg_url");
		adv_in = ebi("plg_adv");
		status = ebi("plg_status");
		audio_opts_div = ebi("plg_audio_options");
		video_opts_div = ebi("plg_video_options");

		url_in.addEventListener("input", function() { });

		var toggles = QSA("#plg_form a.tgl");
		for (var i = 0; i < toggles.length; i++) {
			toggles[i].addEventListener("click", on_change);
		}

		form.onsubmit = submit;
		on_change(); // initial setup
	};

	return r;
})();

ytdlp.init();

/*""")


import os
import sys
import json
import subprocess as sp
import re
import shlex

_ = r"""
modified version of the wget hook

use copyparty as a file downloader by POSTing URLs as
application/x-www-form-urlencoded (for example using
the 📟 message-to-server-log in the web-ui)

example usage as global config:
		--xm aw,f,j,t3600,bin/hooks/youtube.py

parameters explained,
		xm = execute on message-to-server-log
		aw = only users with write-access can use this
		f = fork; don't delay other hooks while this is running
		j = provide message information as json (not just the text)
		c3 = mute all output
		t3600 = timeout and abort download after 1 hour

example usage as a volflag (per-volume config):
		-v srv/inc:inc:r:rw,ed:c,xm=aw,f,j,t3600,bin/hooks/youtube.py
													 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

		(share filesystem-path srv/inc as volume /inc,
		 readable by everyone, read-write for user 'ed',
		 running this plugin on all messages with the params
		 explained above)

example usage as a volflag in a copyparty config file:
		[/inc]
			srv/inc
			accs:
				r: *
				rw: ed
			flags:
				xm: aw,f,j,t3600,bin/hooks/youtube.py

the volflag examples only kicks in if you send the message
while you're in the /inc folder (or any folder below there)
"""

EXECUTABLE = "yt-dlp"
OUTPUT_NAME = "%(title)s.%(ext)s"


def main():
		# log raw input for debugging
		with open("log.txt", "a") as log:
				log.write(sys.argv[1])

		inf = json.loads(sys.argv[1])

		# split user text into URL + extra yt-dlp args
		parts = shlex.split(inf["txt"])
		url = parts[0]
		extra_args = parts[1:]

		# validate YouTube URL
		if re.search(
				r'^((?:https?:)?//)?'
				r'((?:www|m)\.)?'
				r'((?:youtube(?:-nocookie)?\.com|youtu\.be))'
				r'(\/(?:[\w\-]+\?v=|embed\/|live\/|v\/)?)([\w\-]+)'
				r'(\S+)?$',
				url
		) is None:
				raise Exception(f"not a youtube link {url}")

		os.chdir(inf["ap"])
		name = url.split("?")[0].split("/")[-1]
		tfn = "-- DOWNLOADING " + name
		print(f"{tfn}\n", end="")
		open(tfn, "wb").close()

		user_def_out = False
		for a in extra_args:
				if a in ("-o", "--output"):
						user_def_out = True
						continue
				if a.startswith(("-o=", "--output=")):
						user_def_out = True
						continue

		# build final command
		cmd = [EXECUTABLE] + extra_args
		if not user_def_out:
			cmd += ["-o", OUTPUT_NAME]
		cmd.append(url)
	  
		try:
				sp.check_call(cmd)
				status = 0
		except Exception:
				status = 1
				t = "-- FAILED TO DONWLOAD " + name
				print(f"{t}\n", end="")
				open(t, "wb").close()

		os.unlink(tfn)
		sys.exit(status)


if __name__ == "__main__":
		main()
# */
